﻿<#
2020.04.17

Re-write to utilize the precommit.cmd file.  The precommit will now delete several scheduled tasks and other items before it reboots now that the TS will recovery autoamtically into the "Rollback" Section of the TS.

RollBack (Failed Upgrade) Remediation script, this is triggered by a scheduled task that you should set to run daily / start up.
It will check to see if a rollback has happened and then do the required actions to fix the CM Client.

#Checks for Failed Client and resets WMI


Ideas: Grab info from setup\mosetup\volatile to see at which % it failed.

Process:
Script Triggers & Waits 5 Minutes (Safe Guard, making sure the CM Client, if working is up and running)

Checks for Provisioning Mode and Removes
Clears out Running Task Sequence



#>
#Update $RegistryPath Value for your Environment. 
#Sorry, no error handling, it just tries, if it doesn't exist, you'll see some red. :-)
$RegistryPath = "HKLM:\SOFTWARE\WaaS"
#$RegistryRollBack = "HKLM:\SYSTEM\Setup\Rollback" - This isn't created in the Downlevel phase.
$RegistryTemp = "HKLM:\SOFTWARE\RollBack"
$LogFile = "C:\Windows\ccm\Logs\WaaS_RollBackRecovery.log"
$LastOSUpgradeFrom = Get-ItemPropertyValue -Path "$RegistryPath" -Name LastOSUpgradeFrom -ErrorAction SilentlyContinue
$LastOSUpgradeTo = Get-ItemPropertyValue -Path "$RegistryPath" -Name LastOSUpgradeTo -ErrorAction SilentlyContinue
$CurrentRelease = Get-ItemPropertyValue -Path 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion' -Name ReleaseID -ErrorAction SilentlyContinue
$RegistryPathFull = "$RegistryPath\$LastOSUpgradeTo"
$ScriptName = $MyInvocation.MyCommand.Name
$WaaSKeyCurrent = get-item $RegistryPathFull 
$WaaSStage = $WaaSKeyCurrent.GetValue("WaaS_Stage")
$RollbackTriggered = $WaaSKeyCurrent.GetValue("RollbackTSTriggered") #This is Only created if the TS Runs the Rollback Section.
$TSIPUPackageID = $WaaSKeyCurrent.GetValue("IPUPackageID")
$CurrentTimeStamp = Get-Date -f s
[DateTime]$IPUTIME = ($WaaSKeyCurrent.GetValue('IPULastRun'))

# Schedule Task Names
$DefaultSTN = "WaaS_SetLegalNoticeText-Default"
$OSUpgradeCompleteSTN = "WaaS_SetLegalNoticeText-OSUpgradeComplete"
$OSUninstallSuccessfulSTN = "WaaS_SetLegalNoticeText-OSUninstallSuccessful"
$OSUninstallSTN = "WaaS_SetLegalNoticeText-OSUninstall"
$OSUninstallDefaultSTN = "WaaS_SetLegalNoticeText-OSUninstallDefault"
$ForceLockScreenCleanup2HoursSTN = "WaaS_ForceLockScreenCleanup2Hours"
$LockScreenCleanUpSTN = "WaaS_LockScreenCleanUp"
$OSUninstallCleanUpSTN = "WaaS_OSUninstallCleanUp"
$Post_OSUninstall_ProcessesSTN = "WaaS_Post_OSUninstall_Processes"
$RollBackRecoverySTN = "WaaS_SetLegalNoticeText-RollBackRecovery"
$RollBackRecoveryDefaultSTN = "WaaS_SetLegalNoticeText-RollBackRecoveryDefault"
$RollBackRecovery_Process_DownlevelSTN = "WaaS_RollBackRecovery_Process_Downlevel"
$RollBackRecovery_Process_Phase2STN = "WaaS_RollBackRecovery_Process_Phase2"

#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = "RollBack-Phase2",
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }


function Disable-ProvMode
  {
  if ((Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\CCM\CcmExec' 'ProvisioningMode') -eq 'true') 
        {
        $ProvMode = Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\CCM\CcmExec' 'ProvisioningMode' -ErrorAction SilentlyContinue
        CMTraceLog -Message  "ProvMode Status: $ProvMode" -Type 3 -LogFile $LogFile
        CMTraceLog -Message  "Removing Machine From Provisioning Mode and wait 30 seconds" -Type 2 -LogFile $LogFile
        Invoke-WmiMethod -Namespace root\CCM -Class SMS_Client -Name SetClientProvisioningMode -ArgumentList $false
        Start-Sleep -Seconds 30
        $ProvMode = Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\CCM\CcmExec' 'ProvisioningMode' -ErrorAction SilentlyContinue
        if ($provmode -eq "True") 
            {
            CMTraceLog -Message  "ProvMode Status: $ProvMode" -Type 3 -LogFile $LogFile
            CMTraceLog -Message  "Removing Machine From Provisioning Mode" -Type 2 -LogFile $LogFile
            Invoke-WmiMethod -Namespace root\CCM -Class SMS_Client -Name SetClientProvisioningMode -ArgumentList $false
            }   
        Else 
            {
            $ProvMode = Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\CCM\CcmExec' 'ProvisioningMode' -ErrorAction SilentlyContinue
            CMTraceLog -Message  "ProvMode Status: $ProvMode" -Type 1 -LogFile $LogFile
            }

        }
  Else 
        {
        $ProvMode = Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\CCM\CcmExec' 'ProvisioningMode' -ErrorAction SilentlyContinue
        Write-Host "ProvMode Status: $ProvMode" -ForegroundColor Green
        CMTraceLog -Message  "ProvMode Status: $ProvMode" -Type 1 -LogFile $LogFile
        }
  }

#Create Function to Reset TS if running (The Hammer)
 function Reset-TaskSequence
    {
    CMTraceLog -Message "Checking for Stuck Task Sequence" -Type 1 -LogFile $LogFile
    $SMSTSLogLocation ="C:\Windows\ccm\Logs\SMSTSLog" 
    If (Test-Path $SMSTSLogLocation)
        {
        Write-host "TS Appears to be Running"
        CMTraceLog -Message "TS Appears to be Running" -Type 2 -LogFile $LogFile

        $OutputText = "Resetting CM Services to clear out TS - Takes about 3 minutes"
        CMTraceLog -Message  $OutputText -Type 2 -LogFile $LogFile
        Set-Service smstsmgr -StartupType manual
        Start-Service smstsmgr
        start-sleep -Seconds 5 
        #Dump Task Sequence Info from WMI
        if ($TSIPUPackageID)
            {
            if (Get-WmiObject -Namespace Root\CCM\SoftMgmtAgent -Class CCM_TSExecutionRequest | Where-Object {$_.ContentID -eq "$TSIPUPackageID"})
                {
                CMTraceLog -Message "Removing WMI CCM_TSExecutionRequest for $TSIPUPackageID" -Type 2 -LogFile $LogFile
                Get-WmiObject -Namespace Root\CCM\SoftMgmtAgent -Class CCM_TSExecutionRequest | Where-Object {$_.ContentID -eq "$TSIPUPackageID"} | Remove-WmiObject
                }
            }
        Else
            {
            if (Get-WmiObject -Namespace Root\CCM\SoftMgmtAgent -Class CCM_TSExecutionRequest)
                {
                CMTraceLog -Message "Removing WMI CCM_TSExecutionRequest for $TSIPUPackageID" -Type 2 -LogFile $LogFile
                Get-WmiObject -Namespace Root\CCM\SoftMgmtAgent -Class CCM_TSExecutionRequest | Remove-WmiObject
                Get-CimInstance -Namespace root/ccm -ClassName SMS_MaintenanceTaskRequests | Remove-CimInstance
                }
            }

        if ((Get-Process CcmExec -ea SilentlyContinue) -ne $Null) {Get-Process CcmExec | Stop-Process -Force}
        #stop-service ccmexec
        if ((Get-Process TSManager -ea SilentlyContinue) -ne $Null) {Get-Process TSManager| Stop-Process -Force}
        #Stop-Service smstsmgr  
        CMTraceLog -Message  "Starting Services Restart" -Type 1 -LogFile $LogFile
        Start-Sleep -Seconds 5
        Restart-Service -Name CcmExec -Force   
        Start-Service ccmexec
        Start-Sleep -Seconds 5
        Start-Service smstsmgr
        Start-Sleep -Seconds 20
        start-process "shutdown.exe" -ArgumentList "/a"
        if ((Get-Process TSManager -ea SilentlyContinue) -ne $Null) {Get-Process TSManager| Stop-Process -Force}
        Start-Sleep -Seconds 20
        if ((Get-Process CcmExec -ea SilentlyContinue) -ne $Null) {Get-Process CcmExec | Stop-Process -Force}
        Start-Sleep -Seconds 15
        Start-Service ccmexec
        start-process "shutdown.exe" -ArgumentList "/a"
        CMTraceLog -Message  "Services Reset Complete, 60 second pause" -Type 1 -LogFile $LogFile
        start-sleep -Seconds 60
        Start-Process -FilePath C:\windows\ccm\CcmEval.exe
        CMTraceLog -Message  "Trigger CCMEval" -Type 1 -LogFile $LogFile
        #Trigger  Machine  Policy  Update
        Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000021}" |Out-Null
        Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000022}" |Out-Null
        start-process "shutdown.exe" -ArgumentList "/a"
                
        #Check for  Setup  Running, if it is  KILL IT!  It shouldn't be running at this point, bad things might happen.
        if ((Get-Process "SetupHost" -ea SilentlyContinue) -eq $null){$SetupRunning = "False"}
        Else 
            {
            $SetupRunning = "True"
            $OutputText = "Setup Running - Stopping Now"
            CMTraceLog -Message  $OutputText -Type 2 -LogFile $LogFile
            Get-Process "SetupHost"| Stop-Process -Force
            start-sleep -Seconds 30
            start-process "shutdown.exe" -ArgumentList "/a"
            #After waiting 30 seconds, just double checking
            if ((Get-Process "SetupHost" -ea SilentlyContinue) -eq $null)
                {$SetupRunning = "False"}
                Else 
                {
                $SetupRunning = "True"
                $OutputText = "Setup Running - Stopping Now"
                CMTraceLog -Message  $OutputText -Type 2 -LogFile $LogFile
                Get-Process "SetupHost"| Stop-Process -Force               
                }
            }    
        $Global:ResetTSRan = "True"
        }
    Else 
        {
        $global:SMSTSRunning = "False"
        CMTraceLog -Message "No Stuck Task Sequence Found" -Type 1 -LogFile $LogFile
        }
    }

Function ConvertFrom-Logs
{
    [OutputType([PSObject[]])]
    Param
    (
        [Parameter(ValueFromPipeline)]
        [String] $string,
        [String] $LogPath,
        [string] $Date,
        [string] $LogComponent,
        [Int] $Bottom = $Null,
        [DateTime] $After
    )
    
    Begin
    {
    
        If ($LogPath) 
        {
            If (Test-Path -Path $LogPath)
            {
                $string = Get-Content -Raw -Path $LogPath
                $LogFileName = Get-Item -Path $LogPath |Select-Object -ExpandProperty name
            }
            Else
            {
                Return $False
            }
        }
    
        $SccmRegexShort = '\[LOG\[(?:.|\s)+?\]LOG\]'
        $SccmRegexLong = '(?im)((?<=\[LOG\[)((?:.|\s)+?)(\]LOG\]))(.{2,4}?)<(\s*[a-z0-9:\-\.\+]+="[_a-z0-9:\-\.\+]*")+>'

        $ErrorcodeRegex = '(?i)0x[0-9a-fA-F]{8}|(?<=\s)-\d{10}(?=\s)|(?<=code\s*)\d{1,}|(?<=error\s*)\d{1,}'
        $FilePathRegex = '(([a-zA-Z]\:)|(\\))(\\{1}|((\\{1})[^\\]([^/:*?<>"|]*))+)([/:*?<>"|]*(\.[a-zA-Z]+))'
    
        $StringLength = $string.Length    
        $Return = New-Object -TypeName System.Collections.ArrayList
    
    }
    Process
    {
        $TestLength = 500
        If ($StringLength -lt $TestLength)
        {
            $TestLength = $StringLength
        }
    
        #Which type is the log
        If ($StringLength -gt 5)
        {
            # SCCM Log Parshing
            If ([regex]::match($string.Substring(0,$TestLength),$SccmRegexShort).value,'Compiled')
            { 
                $SccmRegex = [regex]::matches($string,$SccmRegexLong)
        
                #foreach Line
                If (-not $Bottom -or $SccmRegex.count -lt $Bottom)
                {
                    $Bottom = $SccmRegex.count
                }
                For ($Counter = 1 ; $Counter -Lt $Bottom + 1; $Counter++)
                { 
                    $r = $SccmRegex[ $SccmRegex.count - $Counter]
                    $Errorcode = ''
                    $FilePath = ''
                    #get Message
                    $Hash = @{}
                    $Hash.Add('Message',$r.groups[2].value)
                    If($LogFileName)
                    {
                        $Hash.Add('LogFileName',$LogFileName)
                    }
                    If($LogPath)
                    {
                        $Hash.Add('LogPath',$LogPath)
                    }
                    #get additional information 
                    $parts = $r.groups |
                    Where-Object -FilterScript {
                        $_.captures.count -gt 1
                    } |
                    Select-Object -ExpandProperty captures

                    Foreach ($p in $parts)
                    {
                        If ($p.value -match '\w=')
                        {
                            $name = $p.value.split('=')[0].trim()
                            $value = $p.value.split('=')[1].replace('"','').Replace('>','').Replace('<','')
                           $Hash.Add($name, $value)
                        }
                    }
          
                    #convert to Datetime .net object
                    If ($Hash.Item('time') -ne $Null -and $Hash.Item('Date') -ne $Null)
                    {
                        $Hash.Add('TempTime', $Hash.Item('time'))
                        $Hash.Item('time') = [datetime] "$($Hash.Item('date')) $($Hash.Item('time').split('+')[0])"
                        If ($Hash.Item('time').gettype() -eq [datetime])
                        {
                            $Hash.Remove('Date')
                        }
                        Else
                        {
                            $Hash.Item('time') = $Hash.Item('TempTime')
                        }
                        $Hash.Remove('TempTime')
                    }
          
                    #get severity information
                    Switch ($Hash.Item('Type'))
                    {
                        0 
                        {
                            $Hash.Add('TypeName', 'Status')
                        }
                        1 
                        {
                            $Hash.Add('TypeName', 'Info')
                        }
                        2 
                        {
                            $Hash.Add('TypeName', 'Error')
                        }
                        3 
                        {
                            $Hash.Add('TypeName', 'Warning')
                        }
                       4 
                        {
                            $Hash.Add('TypeName', 'Verbose')
                        }
                        5 
                        {
                            $Hash.Add('TypeName', 'Debug')
                        }
                    }
          
                    #build object
                    If ($After -GT $Hash.Item('time') -and ([bool] $Hash.Item('time'))) 
                    {
                        $Counter = $SccmRegex.count
                    }
                    Try
                    {
                        [string] $Errorcode = [RegEx]::match($Hash['Message'],$ErrorcodeRegex 
                        ).value
                        $ErrorMSG = [ComponentModel.Win32Exception]::New([int]($Errorcode)).Message
                    }
                    Catch
                    {
                        $Errorcode = ''
                        $Error.removeat(0)
                    }
                    [string] $FilePath = [RegEx]::match($Hash['Message'],$FilePathRegex).value 
                    If ($Errorcode -ne '')
                    {
                        $Hash.Add('ErrorCode', $Errorcode)
                        $Hash.Add('ErrorMessage', $ErrorMSG)
                    }
                    If ($FilePath -ne '')
                    {
                        $Hash.Add('FilePath', $FilePath)
                    }
                    $TempObj = New-Object -TypeName PSobject -Property $Hash
                    $Return.add($TempObj)
                }
                [array]::Reverse($Return)
            }Else
            {
                Write-Warning -Message 'Not Sccm log format'
            }
        }
    }   
    End
    {
        Return $Return
    }
}
Function Start-SetupDiag {
    $SetupDiagPath = "$env:ProgramData\WaaS\SetupDiag.exe"
    if (Test-Path -Path $SetupDiagPath)
        {
        Start-Process -FilePath $SetupDiagPath -PassThru -Wait
        }
    else
        {
        Write-Output "No Setup Diag found in $SetupDiagPath"
        }
}
Function SetupDiagTool {

CMTraceLog -Message  "Starting SetupDiag" -Type 2 -LogFile $LogFile
#Rollback Edition of SetupDiag Script

$tsbuild = Get-ItemPropertyValue -Path "HKLM:\SOFTWARE\WaaS" -Name "LastOSUpgradeTo"
$WaaSRegistryPath = "HKLM:\SOFTWARE\WaaS\$tsbuild"

$SetupDiagRegPath = "HKLM:\SYSTEM\Setup\setupdiag\results"
$SetupDiagRegPathMoSetup = "HKLM:\system\setup\MoSetup\Volatile\SetupDiag\"
$RegPathRollback = "HKLM:\SOFTWARE\WaaS\Rollback\$tsBuild"

if (!(Test-Path ($RegPathRollback))){$Null = New-Item -Path $RegPathRollback -ItemType Directory -Force}
remove-item -Path $RegPathRollback -Force

# Check Default SetupDiag Info First
if (Test-Path $SetupDiagRegPath)
    {
    $SetupDiag = get-item $SetupDiagRegPath
    }

#If Default Setup Diag info is Compat Info... trigger Setup Diag
if ($SetupDiag.GetValue("ProfileName") -eq "CompatScanOnly")
    {
    Start-SetupDiag
    #Using New Info for Reports
    if (Test-Path $SetupDiagRegPathMoSetup)
        {
        Copy-Item -Path $SetupDiagRegPathMoSetup -Destination $RegPathRollback
        }
    }
#If it's not... lets use it for reports
else
    {
    if (Test-Path $SetupDiagRegPath)
        {
        Copy-Item -Path $SetupDiagRegPath -Destination $RegPathRollback -Force
        }
    }


#Setup Diag info should have been copied to the Rollback Registry Location
if (Test-Path -Path $RegPathRollback)
    {
    $RegPathPSItem = get-item -Path $RegPathRollback
    $SetupElapsedTime = $RegPathPSItem.GetValue("UpgradeElapsedTime") 
    if ($SetupElapsedTime)
        {
        if ($SetupElapsedTime -match "-"){$SetupElapsedTimeTotalMinutes = 'N/A'}
        
        else{
            [int]$SetupElapsedTimeHours = $SetupElapsedTime.Split(":")[0]
            [int]$SetupElapsedTimeMinutes = $SetupElapsedTime.Split(":")[1]
            $SetupElapsedTimeTotalMinutes = $SetupElapsedTimeHours * 60 + $SetupElapsedTimeMinutes
            }
        }
    $TargetOSVersion = $RegPathPSItem.GetValue("TargetOSVersion")
    if ($TargetOSVersion){$SetupDiagBuild = ($TargetOSVersion.Split(" ")[0]).split(".")[2]}
    }
if ($RegPathPSItem)
    {
    if ($RegPathPSItem.getvalue("ProfileName") -ne "NoMatchFound" -and $RegPathPSItem.getvalue("ProfileName") -ne "CompatScanOnly")
        {
        $SetupDiagProfile = $RegPathPSItem.getvalue("ProfileName")
        $SetupDiagErrorCode = ((($RegPathPSItem.getvalue("FailureDetails").split(","))[0]).split("=")[1]).replace(" ","")
        $SetupDiagErrorExt = ((($RegPathPSItem.getvalue("FailureDetails").split(","))[1]).split("=")[1]).replace(" ","")
        $SetupDiagFullError = "$SetupDiagErrorCode-$SetupDiagErrorExt"
        if ($SetupDiagFullError)
            {
            CMTraceLog -Message  "Rollback IPUFailedStepReturnCode set to value $SetupDiagFullError" -Type 1 -LogFile $LogFile
            Write-Output "Rollback IPUFailedStepReturnCode set to value $SetupDiagFullError"
            New-ItemProperty -Path $WaaSRegistryPath -Name "IPUFailedStepReturnCode" -Value $SetupDiagFullError -Force
            CMTraceLog -Message  "Rollback IPUReturnStatus set to value $SetupDiagProfile" -Type 1 -LogFile $LogFile
            New-ItemProperty -Path $WaaSRegistryPath -Name "IPUReturnStatus" -Value $SetupDiagProfile -Force
            #New-ItemProperty -Path $WaaSRegistryPath -Name "IPUReturnCode" -Value $SetupDiagFullError -Force  
            if ($TSENV)
                {
                $tsenv.Value("SetupEngineFailedStepReturnCode") = $SetupDiagFullError
                }
            }
        }
        
    else
        {
        New-ItemProperty -Path $WaaSRegistryPath -Name "IPUFailedStepReturnCode" -Value "NoMatchFound" -Force
            if ($TSENV)
            {
            $tsenv.Value("SetupEngineFailedStepReturnCode") = "NoMatchFound"
            }
        }
    }

}

#Fail Safe... if TS Ran Rollback Section, don't run this script

if ((Get-ItemPropertyValue -Path "$RegistryTemp" -Name "OSRollbackRan" -ErrorAction SilentlyContinue) -eq "4") 
    {
    Write-Output "Already Completed Script, no point to run again"
    }
else
    {
    #Start Actions

    #Force the default Windows LockScreen  images to be the actual LockScreen Image.  Update for your envirnment. 
    #Set-ItemProperty -Path 'HKLM:\SOFTWARE\Policies\Microsoft\Windows\Personalization' -Name LockScreenImage -Value "C:\windows\Web\Screen\img100.jpg" -Force
    
    CMTraceLog -Message  "---Starting $ScriptName Script---" -Type 2 -LogFile $LogFile
    #Deleting the Key completely.  Customize this or the previous line for your envirnment. 
    Remove-ItemProperty -Path "HKLM:SOFTWARE\Policies\Microsoft\Windows\Personalization" -Name "LockScreenImage" -Force -ErrorAction SilentlyContinue
    #if((Get-WmiObject win32_computersystem).username -eq $null) {Stop-Process -Name winlogon -Force -Verbose}

    #Update the Legal Notice
    $LegalNotice = "HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System"
    if (Test-Path -path $LegalNotice)
    {
    $LegalNoticeItem = Get-item -path $LegalNotice
    if ($LegalNoticeItem.getValue('legalnoticecaption') -ne $Null)
        {
        $LegalNoticeCaption = Get-ItemPropertyValue -path $LegalNotice -Name "legalnoticecaption" -ErrorAction SilentlyContinue
        if ($LegalNoticeCaption -eq "Upgrade in Progress") 
            {
            Write-Host "  Legal Text is currently displaying: Upgrade in Progress" -ForegroundColor yellow
            CMTraceLog -Message  "  Legal Text is currently displaying: Upgrade in Progress" -Type 2 -LogFile $LogFile
            }
        Else  {
            Write-Host "  Legal Text is currently showing: $LegalNoticeCaption" -ForegroundColor yellow
            CMTraceLog -Message  "  Legal Text is currently showing: $LegalNoticeCaption" -Type 2 -LogFile $LogFile
            
            }
        }
    Else {
        Write-Host "  Legal Text is Blank" -ForegroundColor yellow
        CMTraceLog -Message  "  Legal Text is Blank" -Type 2 -LogFile $LogFile
        }
    }
    CMTraceLog -Message  "  Updating Legal Text to reflect failure to upgrade" -Type 2 -LogFile $LogFile
    Set-ItemProperty -Path $LegalNotice -Name "legalnoticecaption" -Value "Rollback to $CurrentRelease"
    Set-ItemProperty -Path $LegalNotice -Name "legalnoticetext" -Value "System Failed to Upgrade and Rolled Back to $CurrentRelease.  This machine will retry automatically at the next deadline"
    $LegalNoticeItem = Get-item -path $LegalNotice
    $LegalNoticeCaption = Get-ItemPropertyValue -path $LegalNotice -Name "legalnoticecaption" -ErrorAction SilentlyContinue
    Write-Host "  Legal Text is currently showing: $LegalNoticeCaption" -ForegroundColor yellow
    CMTraceLog -Message  "  Legal Text is currently showing: $LegalNoticeCaption" -Type 2 -LogFile $LogFile


    Write-Host "Computer Name: $env:computername" -ForegroundColor Green

    #Run SetupDiag
    if ($RollbackTriggered -ne "TRUE")
        {
        CMTraceLog -Message  "  RollbackTriggered Registry Value not set, running Setup Diag Info" -Type 1 -LogFile $LogFile
        SetupDiagTool
        
        }
    else
        {
        CMTraceLog -Message  "  RollbackTriggered Registry Value Set to True, ASSUMING Setup Diag Info is already populated via the Rollback Section in TS" -Type 2 -LogFile $LogFile

        }

    #Check to see if TS kicked back in (it will create a registry key if it does), and if it does, exit script.

    # - I think I built in enough other logic I don't need to wait 5 extra minutes to start.
    CMTraceLog -Message  "   Waiting 5 Minutes, making sure the TS doesn't kick back in automatically before performing the Reset Function" -Type 1 -LogFile $LogFile
    Start-Sleep -Seconds 120
    CMTraceLog -Message  "   Waiting 5 Minutes, 3 Minutes Left in this long wait..." -Type 1 -LogFile $LogFile
    Start-Sleep -Seconds 120
    CMTraceLog -Message  "   Waiting 5 Minutes, 1 Minute left, so start paying attention" -Type 1 -LogFile $LogFile
    Start-Sleep -Seconds 60
    CMTraceLog -Message  "   Waiting 5 Minutes Completed!" -Type 1 -LogFile $LogFile
    #>

    $WaaSKeyCurrent = get-item $RegistryPathFull 
    if ($WaaSKeyCurrent.GetValue("RollbackTSTriggered") -eq $True)
        {
        CMTraceLog -Message  "Exiting Rollback Recovery" -Type 2 -LogFile $LogFile
        CMTraceLog -Message  "Found Registry Key for Rollback in TS" -Type 2 -LogFile $LogFile
        CMTraceLog -Message  "So the TS should have recovered to fail nicely." -Type 2 -LogFile $LogFile
        
        #Exit
        }

    
        

    #Check for reasons to Run Recovery or Not Run    
    if (!(Test-Path -Path "c:\windows.old")){$TriggerRecovery = $true}
    else {$TriggerRecovery = $false}
    if ((Get-Service -Name CcmExec).StartType -eq "Disabled"){$TriggerRecovery = $true}
    if (!(Get-Process -Name "SetupHost" -ErrorAction SilentlyContinue)){$TriggerRecovery = $true}
    else {$TriggerRecovery = $false}    
    if ($LastOSUpgradeFrom -eq $CurrentRelease -and $WaaSStage -ne "Deployment_Success" -and $WaaSStage -ne $null -and $WaaSStage -ne ""){$TriggerRecovery = $true}

    
    #Trigger Recovery if rules above say so.
    if ($TriggerRecovery -eq $true)
        {
        if (test-path "C:\Windows\ccm\logs\SMSTSlog\smsts.log") {$smstslog = ConvertFrom-Logs -LogPath "C:\Windows\ccm\logs\SMSTSlog\smsts.log" -ErrorAction SilentlyContinue}
        else {$smstslog = ConvertFrom-Logs -LogPath "C:\Windows\ccm\logs\smsts.log" -ErrorAction SilentlyContinue}
        if ($smstslog -ne $null)
            {
            #Search for Unexpected Reboot in SMSTS Log and record it.
            Write-host "Searching for Unexpected Reboots in SMSTS.log" -ForegroundColor Green
            $string = $smstslog | Where-Object -FilterScript { $_.Message -match "STOP/SHUTDOWN control request received"}
            if ($string -ne $null)
                {
                #$Regex = [Regex]::new("(?<=LOG)(.*)(?=LOG)") 
                $Text = $string.Message
                $Time = $string.time
                [DateTime]$IPUTIME = ($WaaSKeyCurrent.GetValue('IPULastRun'))
                if ($time -gt $IPUTIME) 
                    {
                    Write-Host "$text at $Time" -ForegroundColor Yellow
                    CMTraceLog -Message  "$text at $Time" -Type 2 -LogFile $LogFile
                    write-host "  Rebooted after Starting IPU" -ForegroundColor Yellow
                    CMTraceLog -Message  "   Rebooted after Starting IPU" -Type 2 -LogFile $LogFile
                    New-ItemProperty -Path $RegistryPathFull -Name "RR_Reboot01" -Value "Rebooted after Starting IPU" -force | Out-Null
                    write-host "  Started IPU: $IPUTIME" -ForegroundColor Yellow
                    CMTraceLog -Message  "   Started IPU: $IPUTIME" -Type 2 -LogFile $LogFile
                    New-ItemProperty -Path $RegistryPathFull -Name "RR_Reboot02" -Value "Started IPU: $IPUTIME" -force | Out-Null
                    Write-host "  Rebooted: $Time" -ForegroundColor Yellow
                    CMTraceLog -Message  "   Rebooted: $Time" -Type 2 -LogFile $LogFile
                    New-ItemProperty -Path $RegistryPathFull -Name "RR_Reboot03" -Value "Rebooted: $Time" -force | Out-Null
                    $RebootFound = $true
                    if (Test-Path -Path HKLM:\SYSTEM\Setup\MoSetup\Volatile) 
                        {$SetupProgess = Get-Item -Path HKLM:\SYSTEM\Setup\MoSetup\Volatile
                        New-ItemProperty -Path $RegistryPathFull -Name "RR_Reboot04" -Value "Setup Engine at $($SetupProgess.GetValue('SetupProgress'))% when rebooted" -force | Out-Null
                        Write-host "   Setup Engine at $($SetupProgess.GetValue('SetupProgress'))% when rebooted" -ForegroundColor Yellow
                        CMTraceLog -Message  "   Setup Engine at $($SetupProgess.GetValue('SetupProgress'))% when rebooted" -Type 2 -LogFile $LogFile
                        }
                    $TimeRangeMin = ([DateTime]$IPULastRun).AddHours(-4)
                    $TimeRandMax = ([DateTime]$IPULastRun).AddHours(+12)
                    $Events = Get-EventLog -LogName system -Source user32 -After $TimeRangeMin -Before $TimeRandMax
                    if ($Events -ne $Null)
                        {
                        Write-Host "   Event log Data" -ForegroundColor DarkGray
                        CMTraceLog -Message  "   Event log Data" -Type 2 -LogFile $LogFile
                        foreach ($data in $Events)
                            {
                            Write-Host "   Computer reboot triggered @ $($Data.TimeGenerated)" -ForegroundColor Yellow
                            CMTraceLog -Message  "   Computer reboot triggered @ $($Data.TimeGenerated)" -Type 2 -LogFile $LogFile
                            Write-host "   Rebooted By: $($Data.UserName)" -ForegroundColor Yellow
                            CMTraceLog -Message  "   Rebooted By: $($Data.UserName)" -Type 2 -LogFile $LogFile
                            Write-host "   More Info: $($Data.Message)" -ForegroundColor Yellow
                            CMTraceLog -Message  "   More Info: $($Data.Message)" -Type 2 -LogFile $LogFile
                            }
                        }
                    }
                }
            Else
                {
                Write-host "No Unexpected Reboots found in SMSTS.log" -ForegroundColor Green
                CMTraceLog -Message  "No Unexpected Reboots found in SMSTS.log" -Type 2 -LogFile $LogFile
                CMTraceLog -Message  "But you might want to check event logs" -Type 2 -LogFile $LogFile
                }
            }
        
        
        #Check if Running TS & Reset if Needed
        Reset-TaskSequence


        if ((Test-Path $Registrytemp) -ne $True)
            {
                CMTraceLog -Message  "---Starting $ScriptName Script---" -Type 1 -LogFile $LogFile
                #Set OSRollBackRan key to 0, to know where in the script it was if a reboot should occur
                New-Item -Path $RegistryTemp –Force | out-null
                Set-ItemProperty -Path "$RegistryTemp" -Name "OSRollbackRan" -Value "0" -Force

                CMTraceLog -Message  "Starting CCM Disable ProvMode" -Type 1 -LogFile $LogFile
                Disable-ProvMode
                CMTraceLog -Message  "Starting CCM Service & CCMEval" -Type 1 -LogFile $LogFile
                Start-Process "C:\Windows\ccm\CcmEval.exe"
                CMTraceLog -Message  "Triggered CcmEval.exe" -Type 1 -LogFile $LogFile
                #Set OSRollbackRan key to 1, to know where in the script it was if a reboot should occur
                Set-ItemProperty -Path "$RegistryTemp" -Name "OSRollbackRan" -Value "1" -Force
                }
        if ((Get-ItemPropertyValue -Path "$RegistryTemp" -Name "OSRollbackRan") -eq "1")      
            {
                write-host "Starting OSRolbackRun Part 1"
                Write-Host "Waiting 5 Minutes, this is going to feel like forever" -ForegroundColor Gray
                CMTraceLog -Message  "Waiting 5 Minutes for CMClient to become active" -Type 1 -LogFile $LogFile
                Start-Sleep -Seconds 60
                Write-Host "Waiting 4 Minutes, right, what did I tell you, and you're only 20% done waiting" -ForegroundColor Gray
                CMTraceLog -Message  "Waiting 4 Minutes for CMClient to become active" -Type 1 -LogFile $LogFile
                Start-Sleep -Seconds 60
                Write-Host "Waiting 3 Minutes, still enough time to get coffee... run!!!" -ForegroundColor Gray
                CMTraceLog -Message  "Waiting 3 Minutes for CMClient to become active" -Type 1 -LogFile $LogFile
                Start-Sleep -Seconds 60
                Write-Host "Waiting 2 Minutes, congrats, you've reached the 60% complete mark for waiting" -ForegroundColor Gray
                CMTraceLog -Message  "Waiting 2 Minutes for CMClient to become active" -Type 1 -LogFile $LogFile
                Start-Sleep -Seconds 60
                Write-Host "Waiting 1 last Minute, almost there, hang in there, the end of the waiting is near" -ForegroundColor Gray
                CMTraceLog -Message  "Waiting 1 Minutes for CMClient to become active" -Type 1 -LogFile $LogFile
                Start-Sleep -Seconds 60
                Disable-ProvMode
                #Reset Registry Key that feeds into the Task Sequence to provide % complete.
                if (Test-Path -Path HKLM:\SYSTEM\Setup\MoSetup\Volatile)
                    {
                    Remove-ItemProperty -Path HKLM:\SYSTEM\Setup\MoSetup\Volatile -Name SetupProgress -Force
                    }
                #Reset-TaskSequence
                #Set OSRollbackRan key to 2, to know where in the script it was if a reboot should occur
                Set-ItemProperty -Path "$RegistryTemp" -Name "OSRollbackRan" -Value "2" -Force
                }
        if ((Get-ItemPropertyValue -Path "$RegistryTemp" -Name "OSRollbackRan") -eq "2")      
            {     
                write-host "Starting OSRolbackRun Part 2"
                CMTraceLog -Message  "Triggering CM Hardware Inventory" -Type 1 -LogFile $LogFile
                write-host "Triggering CM Hardware Inventory" -ForegroundColor Gray
                Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000001}" | Out-Null
                CMTraceLog -Message  "Triggering CM Machine Policy Retrieval Cycle" -Type 1 -LogFile $LogFile
                write-host "Triggering CM Machine Policy Retrieval Cycle" -ForegroundColor Gray
                Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000021}" | Out-Null
                CMTraceLog -Message  "Triggering CM Machine Policy Evaluation Cycle" -Type 1 -LogFile $LogFile
                Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000022}" | Out-Null
                write-host "Waiting 1 Minutes for Policy to Update" -ForegroundColor Gray
                CMTraceLog -Message  "Waiting 1 Minute for Policy to Update" -Type 1 -LogFile $LogFile
                Start-Sleep -Seconds 60
                CMTraceLog -Message  "Triggering CM Machine Policy Evaluation Cycle" -Type 1 -LogFile $LogFile
                Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000113}" | Out-Null
                #Added Phase of Failure into OSUninstall_TellUsMore, because we don't have any dedicated values for RollBack
                if (Test-Path -Path $RegistryRollBack) {Set-ItemProperty -Path "$RegistryPathFull" -Name "RollbackPhase" -Value "$(Get-ItemPropertyValue -Path $RegistryRollBack -Name "Phase")" -Force}
                Set-ItemProperty -Path "$RegistryPathFull" -Name "WaaS_Stage" -Value "Deployment_RollBack" -Force
                #Set OSRollbackRan key to 3, to know where in the script it was if a reboot should occur, 3 basically means every time the script is triggered, it will do nothing, because it's already completed the required steps
                Set-ItemProperty -Path "$RegistryTemp" -Name "OSRollbackRan" -Value "3" -Force
                }
        if ((Get-ItemPropertyValue -Path "$RegistryTemp" -Name "OSRollbackRan") -eq "3")      
            {   
            write-host "Starting OSRolbackRun Part 3"
            if ($RebootFound -eq $true) {New-ItemProperty -Path $RegistryPathFull -Name "IPUReturnStatus" -Value "Unexpected Reboot during Upgrade"  -force | Out-Null} #Hijacking this Key until the others can be added to HWInv

            #Cleanup Scheduled Tasks
            Unregister-ScheduledTask -TaskName $OSUninstallSTN -Confirm:$false -ErrorAction SilentlyContinue
            if (get-ScheduledTask -TaskName $OSUninstallSTN -ErrorAction SilentlyContinue)
                {CMTraceLog -Message  " $OSUninstallSTN Failed to Delete" -Type 2 -LogFile $LogFile}
            else {CMTraceLog -Message  " $OSUninstallSTN Was able to Delete" -Type 1 -LogFile $LogFile}

            Unregister-ScheduledTask -TaskName $OSUninstallDefaultSTN -Confirm:$false -ErrorAction SilentlyContinue
            if (get-ScheduledTask -TaskName $OSUninstallDefaultSTN -ErrorAction SilentlyContinue)
                {CMTraceLog -Message  " $OSUninstallDefaultSTN Failed to Delete" -Type 2 -LogFile $LogFile}
            else {CMTraceLog -Message  " $OSUninstallDefaultSTN Was able to Delete" -Type 1 -LogFile $LogFile}

            Unregister-ScheduledTask -TaskName $Post_OSUninstall_ProcessesSTN -Confirm:$false -ErrorAction SilentlyContinue
            if (get-ScheduledTask -TaskName $Post_OSUninstall_ProcessesSTN -ErrorAction SilentlyContinue)
                {CMTraceLog -Message  " $Post_OSUninstall_ProcessesSTN Failed to Delete" -Type 2 -LogFile $LogFile}
            else {CMTraceLog -Message  " $Post_OSUninstall_ProcessesSTN Was able to Delete" -Type 1 -LogFile $LogFile}

            Unregister-ScheduledTask -TaskName $OSUninstallCleanUpSTN -Confirm:$false -ErrorAction SilentlyContinue
            if (get-ScheduledTask -TaskName $OSUninstallCleanUpSTN -ErrorAction SilentlyContinue)
                {CMTraceLog -Message  " $OSUninstallCleanUpSTN Failed to Delete" -Type 2 -LogFile $LogFile}
            else {CMTraceLog -Message  " $OSUninstallCleanUpSTN Was able to Delete" -Type 1 -LogFile $LogFile}

            CMTraceLog -Message  "Removed Scheduled Tasks for OSUninstall" -Type 1 -LogFile $LogFile

            Unregister-ScheduledTask -TaskName $RollBackRecoverySTN -Confirm:$false -ErrorAction SilentlyContinue
            if (get-ScheduledTask -TaskName $RollBackRecoverySTN -ErrorAction SilentlyContinue)
                {CMTraceLog -Message  " $RollBackRecoverySTN Failed to Delete" -Type 2 -LogFile $LogFile}
            else {CMTraceLog -Message  " $RollBackRecoverySTN Was able to Delete" -Type 1 -LogFile $LogFile}

            Unregister-ScheduledTask -TaskName $RollBackRecovery_Process_DownlevelSTN -Confirm:$false -Verbose -ErrorAction SilentlyContinue
            if (get-ScheduledTask -TaskName $RollBackRecovery_Process_DownlevelSTN -ErrorAction SilentlyContinue)
                {CMTraceLog -Message  " $RollBackRecovery_Process_DownlevelSTN Failed to Delete" -Type 2 -LogFile $LogFile}
            else {CMTraceLog -Message  " $RollBackRecovery_Process_DownlevelSTN Was able to Delete" -Type 1 -LogFile $LogFile}
            
            CMTraceLog -Message  "Removed Scheduled Tasks for Rollback Items" -Type 1 -LogFile $LogFile

            Remove-Item "$env:ProgramData\OSDReqs" -Force -Recurse -ErrorAction SilentlyContinue
            CMTraceLog -Message  "Removed Upgrade LockScreen Image" -Type 1 -LogFile $LogFile

            Remove-Item "$env:ProgramData\OSUninstall" -Force -Recurse -ErrorAction SilentlyContinue
            CMTraceLog -Message  "Removed OSUninstall Files in ProgramData" -Type 1 -LogFile $LogFile

                
            Set-ItemProperty -Path "$RegistryTemp" -Name "OSRollbackRan" -Value "4" -Force 
               
            Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000021}" | Out-Null
            Invoke-WMIMethod -Namespace root\ccm -Class SMS_CLIENT -Name TriggerSchedule "{00000000-0000-0000-0000-000000000022}" | Out-Null
            CMTraceLog -Message  "---Exiting $ScriptName Script---" -Type 1 -LogFile $LogFile
            Start-Process "C:\Windows\ccm\CcmEval.exe"
            $CurrentTimeStamp = Get-Date -f s
            New-ItemProperty -Path $RegistryPathFull -Name "RR_ScriptComplete" -Value $CurrentTimeStamp -force | Out-Null
            #Exit
            }
        }
    else
        {
        Write-Output "Did not meet requirements to run Rollback Script"
        Write-output  "Current WaaS Status: $((Get-ItemPropertyValue "$RegistryPathFull" 'WaaS_Stage' -ErrorAction SilentlyContinue))"
        CMTraceLog -Message  "Current WaaS Status: $((Get-ItemPropertyValue "$RegistryPathFull" 'WaaS_Stage' -ErrorAction SilentlyContinue))" -Type 1 -LogFile $LogFile
        CMTraceLog -Message  "---Exiting $ScriptName Script---" -Type 1 -LogFile $LogFile
        if ((Test-Path "$RegistryTemp") -eq 'True')
            {
            Remove-Item -Path "$RegistryTemp" -Force
            }
        }
    }